Attribute VB_Name = "mWinDefs"
Option Explicit
'
' Brad Martinez  http://www.mvps.org/ccrp
'
' ======================================================================
' general

Public Const MAX_PATH = 260

Public Enum CBoolean
  CFalse = 0
  CTrue = 1
End Enum

Public Type POINTAPI   ' pt
  x As Long
  y As Long
End Type

Declare Function GetFocus Lib "user32" () As Long
Declare Function SetFocusAPI Lib "user32" Alias "SetFocus" (ByVal hWnd As Long) As Long

Declare Function GetCursorPos Lib "user32" (lpPoint As POINTAPI) As Long
Declare Function ScreenToClient Lib "user32" (ByVal hWnd As Long, lpPoint As Any) As Long  ' lpPoint As POINTAPI) As Long
Declare Function GetWindowRect Lib "user32" (ByVal hWnd As Long, lpRect As RECT) As Long

Declare Function GetParent Lib "user32" (ByVal hWnd As Long) As Long
Declare Function FindWindowEx Lib "user32" Alias "FindWindowExA" (ByVal hwndParent As Long, ByVal hwndChildAfter As Long, ByVal lpszClass As String, ByVal lpszWindow As String) As Long

Declare Function IsWindow Lib "user32" (ByVal hWnd As Long) As CBoolean
Declare Function IsWindowVisible Lib "user32" (ByVal hWnd As Long) As CBoolean
Declare Function ShowWindow Lib "user32" (ByVal hWnd As Long, ByVal nCmdShow As Long) As CBoolean
Public Const SW_HIDE = 0
Public Const SW_SHOW = 5

Declare Function MoveWindow Lib "user32" (ByVal hWnd As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As CBoolean) As Long
Declare Function InvalidateRect Lib "user32" (ByVal hWnd As Long, lpRect As Any, ByVal bErase As CBoolean) As CBoolean

Declare Function LoadLibrary Lib "kernel32" Alias "LoadLibraryA" (ByVal lpLibFileName As String) As Long
Declare Function FreeLibrary Lib "kernel32" (ByVal hLibModule As Long) As Long

' ==============================================================
' SHAutoComplete, exported in shlwapi.dll >= v5.00 (IE5)

' WIN32_IE = 1280 (&H500) in Project Properties dialog (Make tab)
#If (WIN32_IE >= &H500) Then

'  dwFlags values:
Public Enum SHACF_Flags
  SHACF_DEFAULT = &H0         ' Currently (SHACF_FILESYSTEM | SHACF_URLALL)
  SHACF_FILESYSTEM = &H1   ' This includes the File System as well as the rest of the shell (Desktop\My Computer\Control Panel\)
  SHACF_URLHISTORY = &H2   ' URLs in the User's History
  SHACF_URLMRU = &H4           ' URLs in the User's Recently Used list.
  SHACF_URLALL = (SHACF_URLHISTORY Or SHACF_URLMRU)
  SHACF_AUTOSUGGEST_FORCE_ON = &H10000000     ' Ignore the registry default and force the feature on.
  SHACF_AUTOSUGGEST_FORCE_OFF = &H20000000   ' Ignore the registry default and force the feature off.
  SHACF_AUTOAPPEND_FORCE_ON = &H40000000       ' Ignore the registry default and force the feature on. (Also know as AutoComplete)
  SHACF_AUTOAPPEND_FORCE_OFF = &H80000000     ' Ignore the registry default and force the feature off. (Also know as AutoComplete)
End Enum

Declare Function SHAutoComplete Lib "shlwapi.dll" (ByVal hwndEdit As Long, ByVal dwFlags As SHACF_Flags) As Long

'      hwndEdit - HWND of editbox, ComboBox or ComboBoxEx.
'      dwFlags - Flags to indicate what to AutoAppend or AutoSuggest for the editbox.
'
' Returns S_OK if successful, or a standard OLE error value otherwise.
'
' WARNING:
'    Caller needs to have called CoInitialize() or OleInitialize() and cannot
'    call CoUninit/OleUninit until after WM_DESTROY on hwndEdit.
#End If

Declare Function CoInitialize Lib "ole32.dll" (pvReserved As Long) As Long

' ======================================================================
' SHGetSettings, exported in shell32.dll >= v4.71 (IE4)

' WIN32_IE = 1280 (&H500) in Project Properties dialog (Make tab)
#If (WIN32_IE >= &H400) Then

' The shell keeps track of some per-user state to handle display
' options that is of major interest to ISVs.
' The key one requested right now is "DoubleClickInWebView".
'
'  SysFiles are these windows special files:
'      "dll sys vxd 386 drv"
'
'  hidden files are files with the FILE_ATTRIBUTE_HIDDEN attribute
'  system files are files with the FILE_ATTRIBUTE_SYSTEM attribute
'
'  fShowAllObjects  fShowSysFiles    Result
'  -------------------------   ----------------------    ----------
'      0                      0                        hide hidden + SysFiles + system files
'      0                      1                        hide hidden files.
'      1                      0                        show all files.
'      1                      1                        show all files.
'
Public Type SHELLFLAGSTATE
  ' Nonzero if the Show All Files option is enabled or zero otherwise.
  fShowAllObjects As Long
  ' Nonzero if the Hide File Extensions for Known File Types option is disabled or zero otherwise.
  fShowExtensions As Long
  ' Nonzero if the Display Delete Confirmation Dialog box in the Recycle Bin is enabled or zero otherwise.
  fNoConfirmRecycle  As Long
  ' Nonzero if the Do Not Show Hidden Files option is selected or zero otherwise.
  fShowSysFiles As Long
  ' Nonzero if the Display Compressed Files and Folders with Alternate Color option is enabled or zero otherwise.
  fShowCompColor As Long
  ' Nonzero if the Double-Click to Open an Item option is enabled or zero otherwise.
  fDoubleClickInWebView As Long
  ' Nonzero if the Active Desktop  View as Web Page option is enabled or zero otherwise.
  fDesktopHTML As Long
  ' Nonzero if the Classic Style option is enabled or zero otherwise.
  fWin95Classic As Long
  ' Nonzero if the Allow All Uppercase Names option is enabled or zero otherwise.
  fDontPrettyPath As Long
  ' Nonzero if the Show File Attributes in Detail View option is enabled or zero otherwise.
  fShowAttribCol As Long
  ' Nonzero if the Show Map Network Drive Button in Toolbar option is enabled or zero otherwise.
  fMapNetDrvBtn As Long
  ' Nonzero if the Show Info Tips for Items in Folders & Desktop option is enabled or zero otherwise.
  fShowInfoTip As Long
  ' Not used.
  fHideIcons As Long
  ' Not used.
  fRestFlags As Long
End Type

Public Enum ShellSettings
  SSF_SHOWALLOBJECTS = &H1   ' fShowAllObjects
  SSF_SHOWEXTENSIONS = &H2   ' fShowExtensions
  SSF_SHOWCOMPCOLOR = &H8   ' fShowCompColor
  SSF_SHOWSYSFILES = &H20       ' fShowSysFiles
  SSF_DOUBLECLICKINWEBVIEW = &H80   ' fDoubleClickInWebView
  SSF_SHOWATTRIBCOL = &H100                ' fShowAttribCol
  SSF_DESKTOPHTML = &H200                    ' fDesktopHTML
  SSF_WIN95CLASSIC = &H400                     ' fWin95Classic
  SSF_DONTPRETTYPATH = &H800             ' fDontPrettyPath
  SSF_SHOWINFOTIP = &H2000                    ' fShowInfoTip
  SSF_MAPNETDRVBUTTON = &H1000       ' fMapNetDrvBtn
  SSF_HIDEICONS = &H4000                         ' fHideIcons (not used)
  SSF_NOCONFIRMRECYCLE = &H8000&    ' fNoConfirmRecycle
End Enum

' SHGetSettings(LPSHELLFLAGSTATE lpss, DWORD dwMask)
'
' Specify the bits you are interested in in dwMask and they will be
' filled out in the lpsfs structure.
'
' When these settings change, a WM_SETTINGCHANGE message is sent
' with the string lParam value of "ShellState".
Declare Sub SHGetSettings Lib "shell32" (lpsfs As Any, ByVal dwMask As ShellSettings)   ' SHELLFLAGSTATE

#End If

' ======================================================================
' strings

' Converts a Unicode str to a ANSII str.
' Specify -1 for cchWideChar and 0 for cchMultiByte to return str len.
Declare Function WideCharToMultiByte Lib "kernel32" _
                            (ByVal CodePage As Long, _
                            ByVal dwFlags As Long, _
                            lpWideCharStr As Any, _
                            ByVal cchWideChar As Long, _
                            lpMultiByteStr As Any, _
                            ByVal cchMultiByte As Long, _
                            ByVal lpDefaultChar As String, _
                            ByVal lpUsedDefaultChar As Long) As Long
' CodePage
Public Const CP_ACP = 0        ' ANSI code page
Public Const CP_OEMCP = 1   ' OEM code page

Declare Function FormatMessage Lib "kernel32" Alias "FormatMessageA" _
                            (ByVal dwFlags As Long, _
                            lpSource As Any, _
                            ByVal dwMessageId As Long, _
                            ByVal dwLanguageId As Long, _
                            ByVal lpBuffer As String, _
                            ByVal nSize As Long, _
                            Arguments As Long) As Long
' dwFlags
Public Const FORMAT_MESSAGE_FROM_SYSTEM = &H1000
Public Const FORMAT_MESSAGE_IGNORE_INSERTS = &H200
Public Const FORMAT_MESSAGE_MAX_WIDTH_MASK = &HFF

' dwLanguageId
Public Const LANG_USER_DEFAULT = &H400&

' Loads a string resource from the executable file associated with a specified module
Declare Function LoadString Lib "user32" Alias "LoadStringA" (ByVal hInstance As Long, ByVal uID As Long, ByVal lpBuffer As String, ByVal nBufferMax As Long) As Long

'Declare Sub MoveMemory Lib "kernel32" Alias "RtlMoveMemory" (pDest As Any, pSource As Any, ByVal dwLength As Long)
Declare Sub FillMemory Lib "kernel32" Alias "RtlFillMemory" (pDest As Any, ByVal dwLength As Long, ByVal bFill As Byte)

Declare Function lstrcpyA Lib "kernel32" (lpString1 As Any, lpString2 As Any) As Long
Declare Function lstrlenA Lib "kernel32" (lpString As Any) As Long
Declare Function lstrcpyW Lib "kernel32" (lpString1 As Any, lpString2 As Any) As Long
Declare Function lstrlenW Lib "kernel32" (lpString As Any) As Long

' ======================================================================
' menu

Public Type MENUITEMINFO
  cbSize As Long
  fMask As MII_Mask 'Long
  fType As MF_Type 'Long                    ' used if MIIM_TYPE
  fState As MF_State 'Long                    ' used if MIIM_STATE
  wID As Long                       ' used if MIIM_ID
  hSubMenu As Long            ' used if MIIM_SUBMENU
  hbmpChecked As Long      ' used if MIIM_CHECKMARKS
  hbmpUnchecked As Long  ' used if MIIM_CHECKMARKS
  dwItemData As Long          ' used if MIIM_DATA
  dwTypeData As String        ' Long     ' used if MIIM_TYPE
  cch As Long                       ' used if MIIM_TYPE
End Type

Declare Function GetMenu Lib "user32" (ByVal hWnd As Long) As Long
Declare Function GetMenuString Lib "user32" Alias "GetMenuStringA" (ByVal hMenu As Long, ByVal wIDItem As Long, ByVal lpString As String, ByVal nMaxCount As Long, ByVal wFlag As Long) As Long
Declare Function GetMenuItemCount Lib "user32" (ByVal hMenu As Long) As Long
Declare Function GetMenuItemID Lib "user32" (ByVal hMenu As Long, ByVal nPos As Long) As Long
Declare Function SetMenuDefaultItem Lib "user32" (ByVal hMenu As Long, ByVal uItem As Long, ByVal fByPos As Long) As Long
Declare Function SetMenuItemInfo Lib "user32" Alias "SetMenuItemInfoA" (ByVal hMenu As Long, ByVal uItem As Long, ByVal fByPosition As Boolean, lpmii As MENUITEMINFO) As Long
Declare Function InsertMenuItem Lib "user32" Alias "InsertMenuItemA" (ByVal hMenu As Long, ByVal uItem As Long, ByVal fByPosition As Boolean, lpmii As MENUITEMINFO) As Long

Public Enum MII_Mask
  MIIM_STATE = &H1
  MIIM_ID = &H2
  MIIM_SUBMENU = &H4
  MIIM_CHECKMARKS = &H8
  MIIM_TYPE = &H10
  MIIM_DATA = &H20
End Enum

' win40  -- A lot of MF_* flags have been renamed as MFT_* and MFS_* flags
Public Enum MenuFlags
  MF_INSERT = &H0
  MF_ENABLED = &H0
  MF_UNCHECKED = &H0
  MF_BYCOMMAND = &H0
  MF_STRING = &H0
  MF_UNHILITE = &H0
  MF_GRAYED = &H1
  MF_DISABLED = &H2
  MF_BITMAP = &H4
  MF_CHECKED = &H8
  MF_POPUP = &H10
  MF_MENUBARBREAK = &H20
  MF_MENUBREAK = &H40
  MF_HILITE = &H80
  MF_CHANGE = &H80
  MF_END = &H80                    ' Obsolete -- only used by old RES files
  MF_APPEND = &H100
  MF_OWNERDRAW = &H100
  MF_DELETE = &H200
  MF_USECHECKBITMAPS = &H200
  MF_BYPOSITION = &H400
  MF_SEPARATOR = &H800
  MF_REMOVE = &H1000
  MF_DEFAULT = &H1000
  MF_SYSMENU = &H2000
  MF_HELP = &H4000
  MF_RIGHTJUSTIFY = &H4000
  MF_MOUSESELECT = &H8000&
End Enum

Public Enum MF_Type
  MFT_STRING = MF_STRING
  MFT_BITMAP = MF_BITMAP
  MFT_MENUBARBREAK = MF_MENUBARBREAK
  MFT_MENUBREAK = MF_MENUBREAK
  MFT_OWNERDRAW = MF_OWNERDRAW
  MFT_RADIOCHECK = &H200
  MFT_SEPARATOR = MF_SEPARATOR
  MFT_RIGHTORDER = &H2000
  MFT_RIGHTJUSTIFY = MF_RIGHTJUSTIFY
End Enum

Public Enum MF_State
  MFS_GRAYED = &H3
  MFS_DISABLED = MFS_GRAYED
  MFS_CHECKED = MF_CHECKED
  MFS_HILITE = MF_HILITE
  MFS_ENABLED = MF_ENABLED
  MFS_UNCHECKED = MF_UNCHECKED
  MFS_UNHILITE = MF_UNHILITE
  MFS_DEFAULT = MF_DEFAULT
End Enum

' ======================================================================
' Window messages

Declare Function SendMessage Lib "user32" Alias "SendMessageA" _
                            (ByVal hWnd As Long, _
                            ByVal wMsg As Long, _
                            ByVal wParam As Long, _
                            lParam As Any) As Long   ' <---

' Common to most controls
Public Enum WinMsgs
'  WM_NULL = &H0
  WM_CREATE = &H1
'  WM_DESTROY = &H2
'  WM_MOVE = &H3
'  WM_SIZE = &H5
'  WM_SETFOCUS = &H7
  WM_KILLFOCUS = &H8
'  WM_ENABLE = &HA
'  WM_SETREDRAW = &HB
'  WM_PAINT = &HF
'  WM_ERASEBKGND = &H14
'  WM_SYSCOLORCHANGE = &H15
'  WM_WININICHANGE = &H1A
'  WM_SETCURSOR = &H20
'  WM_MOUSEACTIVATE = &H21
'  WM_NEXTDLGCTL = &H28
'
'  WM_SETFONT = &H30
'  WM_GETFONT = &H31
'  WM_WINDOWPOSCHANGING = &H46
'  WM_WINDOWPOSCHANGED = &H47
'  WM_NOTIFY = &H4E
  WM_CONTEXTMENU = &H7B
'  WM_NCCREATE = &H81
'  WM_NCDESTROY = &H82
'  WM_NCCALCSIZE = &H83
'  WM_GETDLGCODE = &H87
  WM_KEYDOWN = &H100
'  WM_KEYUP = &H101
'  WM_CHAR = &H102
'  WM_COMMAND = &H111
'  WM_TIMER = &H113
'  WM_HSCROLL = &H114
'  WM_VSCROLL = &H115
  WM_INITMENUPOPUP = &H117
  WM_MENUSELECT = &H11F
'
'  WM_CTLCOLOREDIT = &H133
'
'  WM_MOUSEMOVE = &H200
  WM_LBUTTONDOWN = &H201
'  WM_LBUTTONUP = &H202
  WM_LBUTTONDBLCLK = &H203
'  WM_RBUTTONDOWN = &H204
'  WM_RBUTTONUP = &H205
'  WM_RBUTTONDBLCLK = &H206
'  WM_MBUTTONDOWN = &H207
'  WM_MBUTTONUP = &H208
'  WM_MBUTTONDBLCLK = &H209

  WM_PARENTNOTIFY = &H210
  WM_USER = &H400
End Enum   ' WinMsgs
' ===================================================================
' statusbar

Declare Function CreateStatusWindow Lib "comctl32.dll" Alias "CreateStatusWindowA" _
                            (ByVal style As Long, _
                            ByVal lpszText As String, _
                            ByVal hwndParent As Long, _
                            ByVal wID As Long) As Long
  
Public Const WM_SIZE = &H5

Public Const WS_VISIBLE = &H10000000
Public Const WS_CHILD = &H40000000

Public Const SBARS_SIZEGRIP = &H100
Public Const CCS_BOTTOM = &H3

Public Enum SB_Messages
  ' wParam: iPart OR uType, lParam: lpszText, rtns T/F
   SB_SETTEXT = (WM_USER + 1)    ' ANSI
  
  ' wParam: nParts, lParam: aWidths (-1 for right align), rtns T/F
  ' Any existing part with a greater index than the number of parts
  ' specified by bParts is destoyed, i.e 8 existing parts (0-7), 6 is
  ' specified for bParts, the last 2 parts (6 & 7) are detroyed.
  ' The text in existing parts is maintained
  SB_SETPARTS = (WM_USER + 4)
  
  ' wParam: nParts, lParam: aRightCoord (can be NULL, -1 for right), rtns nParts
  SB_GETPARTS = (WM_USER + 6)
  
  ' wParam: fSimple, lParam: 0, rtns T/F
  SB_SIMPLE = (WM_USER + 9)
  
  ' wParam: iPart, lParam: lprc, rtns T/F
  SB_GETRECT = (WM_USER + 10)

  ' wParam: iPart, lParam: 0, rtns LOWORD(nChars), HIWORD(SBT_*)
  SB_GETTEXTLENGTH = (WM_USER + 12)
End Enum

' user-defined
Public Const SB_SIMPLEPARTINDEX = 255

' Text drawing operation flags
Public Enum SBT_Flags
  SBT_SUNKEN = &H0   ' Default
  SBT_NOBORDERS = &H100
  SBT_POPOUT = &H200
  SBT_RTLREADING = &H400
  SBT_OWNERDRAW = &H1000   ' in SB_SETTEXT, lParam = item data, sends WM_DRAWITEM
End Enum

Public Type RECT   ' rct
  Left As Long
  Top As Long
  Right As Long
  Bottom As Long
End Type

' ===================================================================
' progressbar

Declare Function CreateWindowEx Lib "user32" Alias "CreateWindowExA" _
                            (ByVal dwExStyle As Long, ByVal lpClassName As String, _
                             ByVal lpWindowName As String, ByVal dwStyle As Long, _
                             ByVal x As Long, ByVal y As Long, _
                             ByVal nWidth As Long, ByVal nHeight As Long, _
                             ByVal hwndParent As Long, ByVal hMenu As Long, _
                             ByVal hInstance As Long, lpParam As Any) As Long

Public Const WS_EX_STATICEDGE = &H20000

Public Const PROGRESS_CLASSA = "msctls_progress32"

' WIN32_IE = 1280 (&H500) in Project Properties dialog (Make tab)
#If (WIN32_IE >= &H300) Then
Public Const PBS_SMOOTH = &H1   ' smooth progress indicator style
#End If

' wParam = (WPARAM) nNewPos, lParam = 0, no rtn
Public Const PBM_SETPOS = (WM_USER + 2)

#If (WIN32_IE >= &H300) Then
' wParam = low, lParam = high, rtns prev range packed in DWORD
Public Const PBM_SETRANGE32 = (WM_USER + 6)
#End If     ' _WIN32_IE >= 0x0300
'

' Returns the low-order word from the given 32-bit value.

Public Function LOWORD(dwValue As Long) As Integer
  MoveMemory LOWORD, dwValue, 2
End Function

' Returns the high-order word from the given 32-bit value.

Public Function HIWORD(dwValue As Long) As Integer
  MoveMemory HIWORD, ByVal VarPtr(dwValue) + 2, 2
End Function

' Combines two integers into a long integer

Public Function MAKELONG(wLow As Long, wHigh As Long) As Long
  MAKELONG = LOWORD(wLow) Or (&H10000 * LOWORD(wHigh))
End Function

' Combines two integers into a long integer

Public Function MAKELPARAM(wLow As Long, wHigh As Long) As Long
  MAKELPARAM = MAKELONG(wLow, wHigh)
End Function

' Returns the top level parent window from the specified window handle.

Public Function GetTopLevelParent(hWnd As Long) As Long
  Dim hwndParent As Long
  Dim hwndTmp
  
  hwndParent = hWnd
  Do
    hwndTmp = GetParent(hwndParent)
    If hwndTmp Then hwndParent = hwndTmp
  Loop While hwndTmp

  GetTopLevelParent = hwndParent

End Function

' Returns the string resource contained within the specifed module
' from the specified string resource ID.

' "&Explore" is @ id 8502 in all shell32.dlls, including NT5 b2

Public Function GetResourceString(sModule As String, idString As Long) As String
  Dim hModule As Long
  Dim sBuf As String * MAX_PATH
  Dim nChars As Long
  
  hModule = LoadLibrary(sModule)
  If hModule Then
    nChars = LoadString(hModule, idString, sBuf, MAX_PATH)
    If nChars Then GetResourceString = Left$(sBuf, nChars)
    Call FreeLibrary(hModule)
  End If
  
End Function

' Returns an ANSII string from a pointer to an ANSII string.

Public Function GetStrFromPtrA(lpszA As Long) As String
  Dim sRtn As String
  
  sRtn = String$(lstrlenA(ByVal lpszA), 0)
  Call lstrcpyA(ByVal sRtn, ByVal lpszA)
  GetStrFromPtrA = sRtn

End Function

' Returns an ANSII string from a pointer to a Unicode string.

Public Function GetStrFromPtrW(lpszW As Long) As String
  Dim sRtn As String
  
  sRtn = String$(lstrlenW(ByVal lpszW) * 2, 0)   ' 2 bytes/char
  Call lstrcpyW(ByVal sRtn, ByVal lpszW)
  GetStrFromPtrW = StrConv(sRtn, vbFromUnicode)

End Function

' Returns the string before first null char encountered (if any) from an ANSII string.

Public Function GetStrFromBufferA(sz As String) As String
  
  If InStr(sz, vbNullChar) Then
    GetStrFromBufferA = Left$(sz, InStr(sz, vbNullChar) - 1)
  Else
    ' If sz had no null char, the Left$ function
    ' above would return a zero length string ("").
    GetStrFromBufferA = sz
  End If

End Function

' Returns the system-defined description of an API error code

Public Function GetAPIErrStr(dwErrCode As Long) As String
  Dim sErrDesc As String * 256   ' max string resource len
  
  Call FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM Or _
                                 FORMAT_MESSAGE_IGNORE_INSERTS Or _
                                 FORMAT_MESSAGE_MAX_WIDTH_MASK, _
                                 ByVal 0&, dwErrCode, LANG_USER_DEFAULT, _
                                 ByVal sErrDesc, 256, 0)
  
  GetAPIErrStr = GetStrFromBufferA(sErrDesc)

End Function

' Sets the statusbar's simple display mode.

Public Function StatusBar_SetSimple(hwndSB As Long, fSimple As Boolean) As Boolean
  StatusBar_SetSimple = SendMessage(hwndSB, SB_SIMPLE, ByVal CLng(Abs(fSimple)), 0)
End Function

' Fills the passed RECT with the dimensions specified statusbar part.

Public Function StatusBar_GetPartRect(hwndSB As Long, bPart As Byte, rc As RECT) As Boolean
  StatusBar_GetPartRect = SendMessage(hwndSB, SB_GETRECT, CLng(bPart), rc)
End Function

' Returns the current text drawing operation for the specified statusbar part.

' SB_GETTEXTLENGTH is used to determine the part's current
' drawing operation. SB_GETTEXT will rtn the exact same value,
' but requires a text buffer.

' When not in simple mode, SB_GETTEXTLENGTH  retrieves the
' text length for the part specified by bPart (0-254, 255 parts max).
' If in simple mode, SB_GETTEXTLENGTH will retrieve the simple
' mode text length *only* if bPart specifies any *valid* part index.
' The simple mode text length is NOT retrieved when bPart = 255
' (as is used to set text w/ SB_SETTEXT). Also applies to
' SB_GETTEXT.

Public Function StatusBar_GetPartDrawOp(hwndSB As Long, bPart As Byte) As SBT_Flags
  ' The text drawing operation for the specified part is
  ' contained in the high word of the message's return value.
  StatusBar_GetPartDrawOp = HIWORD(SendMessage(hwndSB, SB_GETTEXTLENGTH, bPart, 0))
End Function

' Sets the specified statusbar part's text.

' bPart:                  zero-based part to set, 255 = simple mode text.
' wNewDrawOp:   text drawing operation.
' sText:                 text to set

Public Function StatusBar_SetPartText(hwndSB As Long, _
                                                              bPart As Byte, _
                                                              dwNewDrawOp As SBT_Flags, _
                                                              sText As String) As CBoolean
  Dim dwCurDrawOp As SBT_Flags

  ' Get the part's current drawing operation
  ' before it might be updated below.
  dwCurDrawOp = StatusBar_GetPartDrawOp(hwndSB, bPart)
  
  ' Set the text w/ the drawing operation
  StatusBar_SetPartText = SendMessage(hwndSB, SB_SETTEXT, _
                                                                  bPart Or dwNewDrawOp, ByVal sText)
  
  ' Redraw the status bar only if the part's drawing
  ' operation changed (reduces flicker).
  If (dwCurDrawOp <> dwNewDrawOp) Then
    Call InvalidateRect(hwndSB, ByVal 0&, CTrue)
  End If
  
End Function

' Determines if Windows is currently set to open items with a single-click (>= IE4),
' set via: Explorer/View/Option/General tab/Settings/Click items as follows

Public Function IsSingleClickToOpenItem() As Boolean
  Dim dwBuf As Long
  On Error GoTo Out

  ' exported in >= shell32.dll 4.71 (IE4)
  Call SHGetSettings(dwBuf, SSF_DOUBLECLICKINWEBVIEW)
  IsSingleClickToOpenItem = (dwBuf = 0)
  
Out:
End Function
